<?php
/**
 * Show Updated Features modal.
 *
 * @package WP_Smush
 *
 * @since 3.7.0
 *
 * @var string $cta_url URL for the modal's CTA button.
 */

if ( ! defined( 'WPINC' ) ) {
	die;
}

?>

<div class="sui-modal sui-modal-md">
	<div
		role="dialog"
		id="smush-updated-dialog"
		class="sui-modal-content smush-updated-dialog"
		aria-modal="true"
		aria-labelledby="smush-title-updated-dialog"
	>
		<div class="sui-box">
			<div class="sui-box-header sui-flatten sui-content-center sui-spacing-sides--20">
				<figure class="sui-box-banner" aria-hidden="true">
					<img src="<?php echo esc_url( WP_SMUSH_URL . 'app/assets/images/updated/updated.png' ); ?>"
						srcset="<?php echo esc_url( WP_SMUSH_URL . 'app/assets/images/updated/updated.png' ); ?> 1x, <?php echo esc_url( WP_SMUSH_URL . 'app/assets/images/updated/updated' ); ?>@2x.png 2x"
						alt="<?php esc_attr_e( 'Smush Updated Modal', 'wp-smushit' ); ?>" class="sui-image sui-image-center">
				</figure>

				<button class="sui-button-icon sui-button-float--right" data-modal-close="" onclick="WP_Smush.onboarding.hideUpgradeModal()">
					<i class="sui-icon-close sui-md" aria-hidden="true"></i>
				</button>
			</div>

			<div class="sui-box-body sui-content-center sui-spacing-sides--50 sui-spacing-top--0">
				<h3 class="sui-box-title sui-lg" id="smush-title-updated-dialog" style="white-space: normal">
					<?php
					esc_html_e( 'NEW: Serve WebP Images Without Smush CDN', 'wp-smushit' );
					if ( ! WP_Smush::is_pro() ) {
						echo '<span class="sui-tag sui-tag-pro" style="margin-left: 5px">' . esc_html__( 'Pro', 'wp-smushit' ) . '</span>';
					}
					?>
				</h3>

				<p class="sui-description">
					<?php esc_html_e( 'The ability to serve WebP images without utilizing Smush Pro’s CDN was highly requested, and we’re excited to announce it’s now possible!', 'wp-smushit' ); ?>
				</p>

				<p class="sui-description">
					<?php esc_html_e( 'Speed up your site, consume less bandwidth, and serve streamlined images that are around 26% smaller than JPG and PNG formats. All without sacrificing image quality.', 'wp-smushit' ); ?>
				</p>

				<p class="sui-description">
					<?php
					printf(
						/* translators: 1. opening link, 2. closing link. */
						esc_html__( 'With Smush Pro’s new integrated %1$sWebP feature%2$s, you can now easily serve compressed next-gen images to supported browsers. You can also gracefully fallback to JPGs and PNGs for browsers that aren’t compatible.', 'wp-smushit' ),
						'<a href="' . esc_url( $cta_url ) . '" onclick="WP_Smush.onboarding.hideUpgradeModal()">',
						'</a>'
					);
					?>
				</p>

				<a href="<?php echo esc_url( $cta_url ); ?>" class="sui-button" onclick="WP_Smush.onboarding.hideUpgradeModal()">
					<?php esc_html_e( 'Got it', 'wp-smushit' ); ?>
				</a>
			</div>
		</div>
	</div>
</div>
